/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.nether_portal;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.q_misc_util.my_util.IntBox;
import qouteall.q_misc_util.my_util.TriIntPredicate;

public record FastBlockPortalShape(int basePosX, int basePosY, int basePosZ, class_2350.class_2351 axis, int[] localAreaBlockCoords, int[] localFrameWithoutCornerBlockCoords, int[] localFrameCornerBlockCoords, IntBox innerAreaBox, IntBox totalAreaBox) {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static int toLocalA(class_2350.class_2351 axis, int x, int y, int z) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> y;
            case class_2350.class_2351.field_11052 -> x;
            case class_2350.class_2351.field_11051 -> x;
        };
    }

    public static int toLocalB(class_2350.class_2351 axis, int x, int y, int z) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> z;
            case class_2350.class_2351.field_11052 -> z;
            case class_2350.class_2351.field_11051 -> y;
        };
    }

    public static int toWorldX(class_2350.class_2351 axis, int coordOnAxis, int a, int b) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> coordOnAxis;
            case class_2350.class_2351.field_11052 -> a;
            case class_2350.class_2351.field_11051 -> a;
        };
    }

    public static int toWorldY(class_2350.class_2351 axis, int coordOnAxis, int a, int b) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> a;
            case class_2350.class_2351.field_11052 -> coordOnAxis;
            case class_2350.class_2351.field_11051 -> b;
        };
    }

    public static int toWorldZ(class_2350.class_2351 axis, int coordOnAxis, int a, int b) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> b;
            case class_2350.class_2351.field_11052 -> b;
            case class_2350.class_2351.field_11051 -> coordOnAxis;
        };
    }

    public static class_2338 toWorldBlockPos(class_2350.class_2351 axis, int coordOnAxis, int a, int b) {
        return new class_2338(FastBlockPortalShape.toWorldX(axis, coordOnAxis, a, b), FastBlockPortalShape.toWorldY(axis, coordOnAxis, a, b), FastBlockPortalShape.toWorldZ(axis, coordOnAxis, a, b));
    }

    public static long assemble(int a, int b) {
        return class_1923.method_8331((int)a, (int)b);
    }

    public static int getAFromAssemble(long l) {
        return class_1923.method_8325((long)l);
    }

    public static int getBFromAssemble(long l) {
        return class_1923.method_8332((long)l);
    }

    public static FastBlockPortalShape create(class_2350.class_2351 axis, int[] areaBlockCoords, int coordOnAxis) {
        int b;
        int a;
        int i;
        Validate.isTrue((areaBlockCoords.length % 2 == 0 ? 1 : 0) != 0);
        Validate.isTrue((areaBlockCoords.length != 0 ? 1 : 0) != 0);
        int areaBlockNum = areaBlockCoords.length / 2;
        LongOpenHashSet area = new LongOpenHashSet();
        for (int i2 = 0; i2 < areaBlockNum; ++i2) {
            int a2 = areaBlockCoords[i2 * 2];
            int b2 = areaBlockCoords[i2 * 2 + 1];
            area.add(FastBlockPortalShape.assemble(a2, b2));
        }
        LongOpenHashSet frame = new LongOpenHashSet();
        LongOpenHashSet frameCorner = new LongOpenHashSet();
        for (i = 0; i < areaBlockNum; ++i) {
            a = areaBlockCoords[i * 2];
            b = areaBlockCoords[i * 2 + 1];
            if (!area.contains(FastBlockPortalShape.assemble(a + 1, b))) {
                frame.add(FastBlockPortalShape.assemble(a + 1, b));
            }
            if (!area.contains(FastBlockPortalShape.assemble(a - 1, b))) {
                frame.add(FastBlockPortalShape.assemble(a - 1, b));
            }
            if (!area.contains(FastBlockPortalShape.assemble(a, b + 1))) {
                frame.add(FastBlockPortalShape.assemble(a, b + 1));
            }
            if (area.contains(FastBlockPortalShape.assemble(a, b - 1))) continue;
            frame.add(FastBlockPortalShape.assemble(a, b - 1));
        }
        for (i = 0; i < areaBlockNum; ++i) {
            a = areaBlockCoords[i * 2];
            b = areaBlockCoords[i * 2 + 1];
            if (!area.contains(FastBlockPortalShape.assemble(a + 1, b + 1)) && !frame.contains(FastBlockPortalShape.assemble(a + 1, b + 1))) {
                frameCorner.add(FastBlockPortalShape.assemble(a + 1, b + 1));
            }
            if (!area.contains(FastBlockPortalShape.assemble(a + 1, b - 1)) && !frame.contains(FastBlockPortalShape.assemble(a + 1, b - 1))) {
                frameCorner.add(FastBlockPortalShape.assemble(a + 1, b - 1));
            }
            if (!area.contains(FastBlockPortalShape.assemble(a - 1, b + 1)) && !frame.contains(FastBlockPortalShape.assemble(a - 1, b + 1))) {
                frameCorner.add(FastBlockPortalShape.assemble(a - 1, b + 1));
            }
            if (area.contains(FastBlockPortalShape.assemble(a - 1, b - 1)) || frame.contains(FastBlockPortalShape.assemble(a - 1, b - 1))) continue;
            frameCorner.add(FastBlockPortalShape.assemble(a - 1, b - 1));
        }
        int minA = areaBlockCoords[0];
        int maxA = areaBlockCoords[0];
        int minB = areaBlockCoords[1];
        int maxB = areaBlockCoords[1];
        for (int i3 = 1; i3 < areaBlockNum; ++i3) {
            int a3 = areaBlockCoords[i3 * 2];
            int b3 = areaBlockCoords[i3 * 2 + 1];
            if (a3 < minA) {
                minA = a3;
            }
            if (a3 > maxA) {
                maxA = a3;
            }
            if (b3 < minB) {
                minB = b3;
            }
            if (b3 <= maxB) continue;
            maxB = b3;
        }
        IntBox innerAreaBox = new IntBox(FastBlockPortalShape.toWorldBlockPos(axis, coordOnAxis, minA, minB), FastBlockPortalShape.toWorldBlockPos(axis, coordOnAxis, maxA, maxB));
        IntBox totalAreaBox = new IntBox(FastBlockPortalShape.toWorldBlockPos(axis, coordOnAxis, minA - 1, minB - 1), FastBlockPortalShape.toWorldBlockPos(axis, coordOnAxis, maxA + 1, maxB + 1));
        long firstFramePosAssemble = frame.iterator().nextLong();
        int baseA = FastBlockPortalShape.getAFromAssemble(firstFramePosAssemble);
        int baseB = FastBlockPortalShape.getBFromAssemble(firstFramePosAssemble);
        class_2338 firstFramePos = FastBlockPortalShape.toWorldBlockPos(axis, coordOnAxis, baseA, baseB);
        int[] localAreaBlockCoords = new int[areaBlockNum * 2];
        for (int i4 = 0; i4 < areaBlockNum; ++i4) {
            int a4 = areaBlockCoords[i4 * 2];
            int b4 = areaBlockCoords[i4 * 2 + 1];
            localAreaBlockCoords[i4 * 2] = a4 - baseA;
            localAreaBlockCoords[i4 * 2 + 1] = b4 - baseB;
        }
        int[] localFrameWithoutCornerBlockCoords = new int[frame.size() * 2];
        LongIterator framePosIter = frame.longIterator();
        for (int i5 = 0; i5 < frame.size(); ++i5) {
            long l = framePosIter.nextLong();
            int a5 = FastBlockPortalShape.getAFromAssemble(l);
            int b5 = FastBlockPortalShape.getBFromAssemble(l);
            localFrameWithoutCornerBlockCoords[i5 * 2] = a5 - baseA;
            localFrameWithoutCornerBlockCoords[i5 * 2 + 1] = b5 - baseB;
        }
        int[] localFrameCornerBlockCoords = new int[frameCorner.size() * 2];
        LongIterator frameCornerPosIter = frameCorner.longIterator();
        for (int i6 = 0; i6 < frameCorner.size(); ++i6) {
            long l = frameCornerPosIter.nextLong();
            int a6 = FastBlockPortalShape.getAFromAssemble(l);
            int b6 = FastBlockPortalShape.getBFromAssemble(l);
            localFrameCornerBlockCoords[i6 * 2] = a6 - baseA;
            localFrameCornerBlockCoords[i6 * 2 + 1] = b6 - baseB;
        }
        return new FastBlockPortalShape(firstFramePos.method_10263(), firstFramePos.method_10264(), firstFramePos.method_10260(), axis, localAreaBlockCoords, localFrameWithoutCornerBlockCoords, localFrameCornerBlockCoords, innerAreaBox, totalAreaBox);
    }

    @Nullable
    public static FastBlockPortalShape fromTag(class_2487 tag) {
        int axisInt = tag.method_10550("axis");
        if (axisInt < 0 || axisInt > 2) {
            LOGGER.error("invalid axis {}", (Object)tag);
            return null;
        }
        class_2350.class_2351 axis = class_2350.class_2351.values()[axisInt];
        class_2499 positions = tag.method_10554("poses", 3);
        int numNum = positions.size();
        if (numNum == 0 || numNum % 3 != 0) {
            LOGGER.error("invalid poses tag {}", (Object)tag);
            return null;
        }
        int positionNum = numNum / 3;
        int firstPointX = positions.method_10600(0);
        int firstPointY = positions.method_10600(1);
        int firstPointZ = positions.method_10600(2);
        IntArrayList areaBlockCoords = new IntArrayList();
        if (axis != class_2350.class_2351.field_11048) {
            areaBlockCoords.add(firstPointX);
        }
        if (axis != class_2350.class_2351.field_11052) {
            areaBlockCoords.add(firstPointY);
        }
        if (axis != class_2350.class_2351.field_11051) {
            areaBlockCoords.add(firstPointZ);
        }
        int coordOnAxis = axis.method_10173(firstPointX, firstPointY, firstPointZ);
        for (int i = 1; i < positionNum; ++i) {
            int z;
            int y;
            int x = positions.method_10600(i * 3);
            if (axis.method_10173(x, y = positions.method_10600(i * 3 + 1), z = positions.method_10600(i * 3 + 2)) != coordOnAxis) {
                LOGGER.error("invalid block position in {} at {}", (Object)tag, (Object)i);
                return null;
            }
            if (axis != class_2350.class_2351.field_11048) {
                areaBlockCoords.add(x);
            }
            if (axis != class_2350.class_2351.field_11052) {
                areaBlockCoords.add(y);
            }
            if (axis == class_2350.class_2351.field_11051) continue;
            areaBlockCoords.add(z);
        }
        return FastBlockPortalShape.create(axis, areaBlockCoords.toIntArray(), coordOnAxis);
    }

    public class_2487 toTag() {
        int coordOnAxis = this.axis.method_10173(this.basePosX, this.basePosY, this.basePosZ);
        class_2487 tag = new class_2487();
        tag.method_10569("axis", this.axis.ordinal());
        class_2499 positions = new class_2499();
        for (int i = 0; i < this.localAreaBlockCoords.length / 2; ++i) {
            int a = this.localAreaBlockCoords[i * 2];
            int b = this.localAreaBlockCoords[i * 2 + 1];
            positions.add((Object)class_2497.method_23247((int)(FastBlockPortalShape.toWorldX(this.axis, 0, a, b) + this.basePosX)));
            positions.add((Object)class_2497.method_23247((int)(FastBlockPortalShape.toWorldY(this.axis, 0, a, b) + this.basePosY)));
            positions.add((Object)class_2497.method_23247((int)(FastBlockPortalShape.toWorldZ(this.axis, 0, a, b) + this.basePosZ)));
        }
        tag.method_10566("poses", (class_2520)positions);
        return tag;
    }

    public static FastBlockPortalShape fromBlockPortalShape(BlockPortalShape blockPortalShape) {
        return FastBlockPortalShape.fromTag(blockPortalShape.toTag());
    }

    public BlockPortalShape toBlockPortalShape() {
        return BlockPortalShape.fromTag(this.toTag());
    }

    public boolean matchShape(int newBaseX, int newBaseY, int newBaseZ, TriIntPredicate framePredicate, TriIntPredicate areaPredicate) {
        int z;
        int y;
        int x;
        int b;
        int a;
        for (int frameI = 0; frameI < this.localFrameWithoutCornerBlockCoords.length / 2; ++frameI) {
            a = this.localFrameWithoutCornerBlockCoords[frameI * 2];
            b = this.localFrameWithoutCornerBlockCoords[frameI * 2 + 1];
            x = FastBlockPortalShape.toWorldX(this.axis, 0, a, b) + newBaseX;
            if (framePredicate.test(x, y = FastBlockPortalShape.toWorldY(this.axis, 0, a, b) + newBaseY, z = FastBlockPortalShape.toWorldZ(this.axis, 0, a, b) + newBaseZ)) continue;
            return false;
        }
        for (int areaI = 0; areaI < this.localAreaBlockCoords.length / 2; ++areaI) {
            a = this.localAreaBlockCoords[areaI * 2];
            b = this.localAreaBlockCoords[areaI * 2 + 1];
            x = FastBlockPortalShape.toWorldX(this.axis, 0, a, b) + newBaseX;
            if (areaPredicate.test(x, y = FastBlockPortalShape.toWorldY(this.axis, 0, a, b) + newBaseY, z = FastBlockPortalShape.toWorldZ(this.axis, 0, a, b) + newBaseZ)) continue;
            return false;
        }
        return true;
    }

    public FastBlockPortalShape withNewBase(int newBaseX, int newBaseY, int newBaseZ) {
        return new FastBlockPortalShape(newBaseX, newBaseY, newBaseZ, this.axis, this.localAreaBlockCoords, this.localFrameWithoutCornerBlockCoords, this.localFrameCornerBlockCoords, this.innerAreaBox, this.totalAreaBox);
    }
}

